<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Order {
    public static function insertShippingDetails($objShippingVo)
    {
            $objResult                           = new stdClass();
            $tableName                           = DbHelper::setTablePrefix('shipping_details');
            $shippingId                            = DbHelper::insert($tableName, array(  'norder_id'                  =>  generalMethods::escapeString($objShippingVo->norder_id),
                                                                                     'vshipping_name'                        =>  generalMethods::escapeString($objShippingVo->vshipping_name),
                                                                                     'nshipping_cost'                      =>  generalMethods::escapeString($objShippingVo->nshipping_cost),
                                                                                     'nshipping_weight'                      =>  generalMethods::escapeString($objShippingVo->nshipping_weight),
                                                                                     'vshipping_currency'                       =>  generalMethods::escapeString($objShippingVo->vshipping_currency),
                                                                                     'dshipped_date'                       =>  'now()',
                                                                                     'nshp_status'                       =>  generalMethods::escapeString($objShippingVo->nshp_status),
                                                                                     'user_id'                       =>  generalMethods::escapeString($objShippingVo->user_id),
                                                                                     'seller_id'                       =>  generalMethods::escapeString($objShippingVo->seller_id)));
         if($shippingId) {
            $objResult->status                  =    SUCCESS;
            $objResult->data                    =    $shippingId;
         }else{
             $objResult->status                 =    ERROR;
         }
         return $objResult;
    }


      public static function updateSellerCoupcodeInformationtoOrder($couponcodeObjVo)
    {
            $objResult                           = new stdClass();
            $tableName                           = DbHelper::setTablePrefix('orders');
            $where                               = "order_id = ".generalMethods::escapeString($couponcodeObjVo->order_id). " ";
            $orderId                              = DbHelper::update($tableName,array('couponCode' => generalMethods::escapeString($couponcodeObjVo->couponCode),
                                                            'couponCodeDiscount' => generalMethods::escapeString($couponcodeObjVo->couponCodeDiscount),
                                                            'couponCodeSeller_Id' => generalMethods::escapeString($couponcodeObjVo->couponCodeSeller_Id)),$where);
         if($orderId) {
            $objResult->status                  =    SUCCESS;
            $objResult->data                    =    $orderId;
         }else{
             $objResult->status                 =    ERROR;
         }

         return $objResult;
    }
    
     public static function is_free_ship_product($productID)
    {
                 $objResult                      = new stdClass();
                 $tableName                      = DbHelper::setTablePrefix('order_details');
                 
                 if(!empty($productID)) {
                 $selectCase                     = "product_id =".generalMethods::escapeString($productID);
                 $objResultRow                   = DbHelper::selectSingleValue($tableName,'allow_free_shipping',$selectCase);
         // If user exists then assign user data to result object
                 }
                 if($objResultRow) {
                      $objResult->status         =    SUCCESS;
                      $objResult->data           =   $objResultRow; // Assign user record  to object
                      
                 }
                 else{
                     $objResult->status          =  ERROR;
                  }

         return $objResult;

    }
    
    
     public static function check_free_ship_product_text($productID)
    {    
                $freeShipText       =   '';
                 if(!empty($productID)) {
                       $freeshipObj    =   self::is_free_ship_product($productID);                       
                        if($freeshipObj->status==SUCCESS)
                        {
                            $FreeshipFlag  = $freeshipObj->data; 
                            
                            if($FreeshipFlag=='Y')
                            {
                                $freeShipText   =  "( ". FREE_SHIP_TEXT ." )";
                            }
                        }
         // If user exists then assign user data to result object
                 }
                 
         return $freeShipText;

    }
    
     public static function orderShippingCost($orderID,$sellerId='')
    {
                 $objResult                      = new stdClass();
                 $tableName                      = DbHelper::setTablePrefix('shipping_details');

                 $shippingCost                  =   0;
                 
                 if(!empty($orderID)) {
                 $selectCase                     = ($sellerId==NULL)?"norder_id =".generalMethods::escapeString($orderID):"norder_id =".generalMethods::escapeString($orderID)." AND seller_id =".$sellerId;
                 $objResultRow                   = DbHelper::selectSingleValue($tableName,'SUM(nshipping_cost) as shipping_total',$selectCase);
         // If user exists then assign user data to result object
                 }
                 //echopre($objResultRow);
                 if($objResultRow!='') {
                      $shippingCost             =   $objResultRow;
                      
                 }
                

         return $shippingCost;

    }
    
     // function to show digital icon
     public static function showDigitalItemIcon($digitalProductFlag)
    {
         if($digitalProductFlag=="Y"){
             $image ='<img src="'.SITE_URL.'/images/digital_icon.png" alt="'.DIGITAL_PRODUCT_FLAG.'" title="'.DIGITAL_PRODUCT_FLAG.'">';
         }else{
             $image ="";
         }
         
         return $image;

    }
    
    //Function to show icontext
    public static function showIconTexts($orderId){
        $tableName                      = DbHelper::setTablePrefix('order_details');
        $selectCase                     = "order_id =".generalMethods::escapeString($orderId)." AND (digital_product_flag = 'Y' OR subscription_product_flag='Y') ";
        $digital_subscription_prd_count = DbHelper::selectSingleValue($tableName,'COUNT(order_detail_id) as count',$selectCase);
        
        if($digital_subscription_prd_count>0){
            $retVal ='<div><img src="'.SITE_URL.'/images/digital_icon.png" alt="'.DIGITAL_PRODUCT_FLAG.'" title="'.DIGITAL_PRODUCT_FLAG.'">'.DIGITAL_PRODUCT_MARK_TEXT;
            //$retVal.='&nbsp;&nbsp;<img src="'.SITE_URL.'/images/subscription_icon.jpg" alt="'.SUBSCRIPTION_PRODUCT_FLAG.'" title="'.SUBSCRIPTION_PRODUCT_FLAG.'">'.SUBSCRIPTION_PRODUCT_MARK_TEXT."</div>";
        }else{
            $retVal = "&nbsp;";
        }
        
        return $retVal;
        
    }



    // Get Order Tax Total

     public static function getorderTaxTotal($orderID,$sellerId='')
    {
                 $objResult                      = new stdClass();
                 $tableName                      = DbHelper::setTablePrefix('order_details');

                 $taxTotal                  =   0;

                 if(!empty($orderID)) {
                 $selectCase                     = ($sellerId==NULL)?"order_id =".generalMethods::escapeString($orderID):"order_id =".generalMethods::escapeString($orderID)." AND artist_id =".$sellerId;
                 $objResultRow                   = DbHelper::selectSingleValue($tableName,'SUM(product_tax) as tax_total',$selectCase);
         // If user exists then assign user data to result object
                 }
                 //echopre($objResultRow);
                 if($objResultRow!='') {
                      $taxTotal             =   $objResultRow;

                 }


         return $taxTotal;

    }
    
    
    //get Seller Coupon Code Discount 
    
     public static function getorderCoponDiscount($orderID,$sellerId='')
    {
                 $objResult                      = new stdClass();
                 $tableName                      = DbHelper::setTablePrefix('orders');

                 $taxTotal                  =   0;

                 if(!empty($orderID)) {
                 $selectCase                     = ($sellerId==NULL)?"order_id =".generalMethods::escapeString($orderID):"order_id =".generalMethods::escapeString($orderID)." AND couponCodeSeller_Id =".$sellerId;
                 $objResultRow                   = DbHelper::selectSingleValue($tableName,'(couponCodeDiscount +nused_gift_amount) as discount',$selectCase);
         // If user exists then assign user data to result object
                 }
                 //echopre($objResultRow);
                 if($objResultRow!='') {
                      $discount             =   $objResultRow;

                 }


         return $discount;

    }
    
    
     public static function checkShippingBlockRequiredForOrder($orderId = '') {
        $objResult = new stdClass();

        $orderTotalPrdCount = 0;
        $orderDigitalCount = 0;
        $orderGiftCount = 0;
        $hide_shipping_division = 0;
        $cartFreeShiptCount = 0;

        //Get Cart Total Count
        $objCart = self::getOrderProductCount($orderId);
        if ($objCart->status == SUCCESS) {
            $cartObjVal = $objCart->data;
            $orderTotalPrdCount = $cartObjVal->product_count;
        }

        // Get Digital Products Count
        $objDigitalCart = self::getOrderDigitalItemsCount($orderId);
        if ($objDigitalCart->status == SUCCESS) {
            $orderDigitalObjVal = $objDigitalCart->data;
            $orderDigitalCount = $orderDigitalObjVal->digitalcount;
        }

        //Get Gift Product Count in order
        $objGiftCart = self::getOrderGiftCertificateItemsCount($orderId);
        if ($objGiftCart->status == SUCCESS) {
            $cartGiftObjVal = $objGiftCart->data;
            $orderGiftCount = $cartGiftObjVal->gift_count;
        }


        // Get Physical Items Count in order

        $objPhysicalCart = self::getOrderPhysicalItemsCount($orderId);
        if ($objPhysicalCart->status == SUCCESS) {
            $orderPhysicalObjVal = $objPhysicalCart->data;
            $orderPhysicalCount = $orderPhysicalObjVal->physicalcount;
        }


        $orderDigitalAndGiftItemsCount = $orderGiftCount + $orderDigitalCount;

        if ($orderTotalPrdCount > 0) {
            if ((int) $orderTotalPrdCount == ((int) $orderDigitalAndGiftItemsCount)) {
                $hide_shipping_division = 1;
            }
        }

        return $hide_shipping_division;
    }
    
    
    public static function getOrderProductCount($orderId='')
    {
    	$objResult                      =   new stdClass();
    	$tableName                      =   DbHelper::setTablePrefix('order_details');
    	$andCase                        =   '';
              
    	 if($orderId!='')
                 $andCase.= ' order_id = '.$orderId;          
    	
         $objResultRow                   =   DbHelper::selectRecord($tableName,'COUNT(order_detail_id) as product_count',$andCase);
    	
    	if($objResultRow){    		
                $objResult->status        = SUCCESS;
    		$objResult->data          =    $objResultRow;
        }
    	else {
    		$objResult->status      =   ERROR;    		
    	}
    	return $objResult;
    	 
    }
    
     public static function getOrderDigitalItemsCount($orderId='')
    {
    	$objResult                      =   new stdClass();
    	$tableName                      =   DbHelper::setTablePrefix('order_details');
    	$andCase                        =   '';
        
    	 if($orderId!='')
                 $andCase.= ' order_id = '.$orderId.' AND digital_product_flag="Y"';  
    	
        
    	$objResultRow                   =  DbHelper::selectRecord($tableName,'COUNT(order_detail_id) as digitalcount',$andCase);
    	
    	if($objResultRow)    		
        {
                $objResult->status        =    SUCCESS;
    		$objResult->data          =    $objResultRow;
        }
    	else {
    		$objResult->status        =   ERROR;    		
    	}
    	return $objResult;
    	 
    }
    
     public static function getOrderGiftCertificateItemsCount($orderId='')
    {
    	$objResult                      =   new stdClass();
    	$tableName                      =   DbHelper::setTablePrefix('order_details');
    	$andCase                        =   '';
        
    	 if($orderId!='')
                 $andCase.= ' order_id = '.$orderId.' AND gift_product_flag = "Y"  ';
           

    	$objResultRow                   =   DbHelper::selectRecord($tableName,'COUNT(order_detail_id) as gift_count',$andCase);
    
       
    	if($objResultRow)    
        {
                $objResult->status        =    SUCCESS;
    		$objResult->data          =    $objResultRow;
        }
    	else {
    		$objResult->status        =   ERROR;    		
    	}
    	return $objResult;
    	 
    }
    
    
    public static function getOrderPhysicalItemsCount($orderId='')
    {
        global $tableprefix;    
    	$objResult                      =   new stdClass();
                
        $QueryPhysicaltems="SELECT count(ord_det.order_detail_id) as physicalcount
                    FROM ".$tableprefix."order_details ord_det
                    INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = ord_det.product_option_id
                    INNER JOIN ".$tableprefix."products p ON p.product_id = ord_det.product_id    
                    WHERE p.allow_free_shipping!='Y' AND ord_det.gift_product_flag='N'  AND ord_det.digital_product_flag ='N' ";
                    if($orderId!='')
                    {
                      $QueryPhysicaltems.=' AND ord_det.order_id = '.$orderId;
                    }
                   
            	
        $objResultRow                   =  DbHelper::customRecord($QueryPhysicaltems);    	
    	if($objResultRow)    		
        {
                $objResult->status        =    SUCCESS;
    		$objResult->data          =    $objResultRow;
        }
    	else {
    		$objResult->status        =   ERROR;    		
    	}
    	return $objResult;
    	 
    }
    
    
    //get Items in order by sellerwise
    public static function getsellerItemsinOrder($orderId='',$sellerid)
    {
    	
    	$tableName                      =   DbHelper::setTablePrefix('order_details');
    	$andCase                        =   '';
    	 if($sellerid!='')
                 $andCase.= ' order_id = '.generalMethods::escapeString($orderId).' AND  '; 
         
         if($orderId!='')
                 $andCase.= ' artist_id = '.generalMethods::escapeString($sellerid).' '; 
         
         $andCase        = rtrim($andCase,"AND");
        
    	$objResultRow                   =  DbHelper::selectResult($tableName,'*',$andCase);
    
    	return $objResultRow;
    	 
    }
    
        
}
?>
